VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsFilters"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Filters() As FTLS
Private Type FTLS
    FilterString  As String 'Either a username or a message.
    FilterType    As FTYPE
End Type

Public Enum FTYPE
    F_MESSAGE = 1
    F_USER = 2
End Enum


Public Function getFilter(ByRef FilterString As String, ByRef FilterType As FTYPE) As Boolean
    Dim i As Integer
    For i = 0 To UBound(Filters) - 1
        'Test if the filter matches a wildcard AND the same type.
        If (Wildcard(FilterString, Filters(i).FilterString) = True And (FilterType = Filters(i).FilterType)) Then
            'Match was found:
            getFilter = True
            Exit Function
        End If
    Next i
End Function

Public Function addFilter(ByRef FilterString As String, ByRef FilterType As FTYPE) As Boolean
    If (indexFilter(FilterString, FilterType) = -1) Then
        'Set values
        With Filters(UBound(Filters))
            .FilterString = FilterString
            .FilterType = FilterType
        End With
        'Increase the upper bound and preserve the array
        ReDim Preserve Filters(UBound(Filters) + 1)
        'Set function equal to True
        addFilter = True
    End If
End Function

Public Function removeFilter(ByRef FilterString As String, ByRef FilterType As FTYPE) As Boolean
    'First find the index
    Dim filterIndex As Integer
    Dim i           As Integer
    If (UBound(Filters) = 0) Then Exit Function
    filterIndex = indexFilter(FilterString, FilterType)
    'Found the filter, remove it now. Validate index so we do not get any subscript errors.
    If (filterIndex <> -1 And filterIndex < UBound(Filters)) Then
        For i = filterIndex To UBound(Filters) - 1
            'Set each previous array to the one above it.
            Filters(i) = Filters(i + 1)
        Next i
        'Preserve array
        ReDim Preserve Filters(UBound(Filters) - 1)
        removeFilter = True
    End If
End Function

Private Function indexFilter(ByRef FilterString As String, ByRef FilterType As FTYPE) As Integer
    Dim i As Integer
    For i = 0 To UBound(Filters) - 1
        'Test if the filter matches _exactly_ (non-case sensitive) AND the same type.
        If (StrComp(FilterString, Filters(i).FilterString, vbTextCompare) = 0 And (FilterType = Filters(i).FilterType)) Then
            'Match was found:
            indexFilter = i
            Exit Function
        End If
    Next i
    'Not found, handle odd index
    indexFilter = -1
End Function

Public Function getFiltersArray(ByRef FilterType As FTYPE) As String()
    Dim i As Integer
    Dim FilterArray() As String
    ReDim FilterArray(0)
    For i = 0 To UBound(Filters) - 1
        If (Filters(i).FilterType = FilterType) Then
            FilterArray(UBound(FilterArray)) = Filters(i).FilterString
            ReDim Preserve FilterArray(UBound(FilterArray) + 1)
        End If
    Next i
    getFiltersArray = FilterArray
End Function

Public Function resetFilters()
    ReDim Filters(0)
End Function

Public Function countFilters() As Integer
    countFilters = UBound(Filters)
End Function

Private Sub Class_Initialize()
    ReDim Filters(0)
End Sub

Private Sub Class_Terminate()
    ReDim Filters(0)
End Sub
